//
//  ESP8266 and the Arduino IDE Part 10: Environment monitor station
//  ESP8266-10C_sketch05_TemperatureSwitch2
//

char ssid[] = "mySSID";
char pass[]= "myPassword";



#include "webpage.h"

#include <ESP8266WiFi.h>
#include <WebSocketsServer.h>
 
WiFiServer server(80);
WebSocketsServer webSocket = WebSocketsServer(81);

#include "DHT.h"
#define DHTPIN D6     
#define DHTTYPE DHT11   
DHT dht(DHTPIN, DHTTYPE);

#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 20, 4);

byte const pinSWITCH = D5;
byte const pinLDR = A0;

boolean switchPinState = LOW;
int brightness = 0;
float humidity = 0;       
float tempC = 0;
float tempF = 0;

boolean DHTreadingsOK = false;
boolean updateWebpage = false;

long sensorUpdateFrequency = 5000;
long timeNow = 0;
long timePrev = 0;

 
void setup()
{
  Serial.begin(9600);
  while (!Serial) {;}
  Serial.println();
  Serial.println("Serial started at 9600");
  Serial.println();
  
  lcd.begin(20,4);
  lcd.init();
  lcd.backlight();
  
  pinMode(pinSWITCH, INPUT); 
  dht.begin();

 
  // Connect to a WiFi network
  Serial.print("Connecting to ");  Serial.println(ssid); 
  
  // try to connect to the network
  WiFi.begin(ssid,pass);
  
  // connection with timeout
  int count = 0; 
  while ( (WiFi.status() != WL_CONNECTED) && count < 17) 
  {
      Serial.print(".");    count++;     delay(500);
  }
 
  if (WiFi.status() != WL_CONNECTED)
  { 
     Serial.println("");  Serial.print("Failed to connect to ");  Serial.println(ssid);
     while(1);
  }
  Serial.println("");
  Serial.print("Connected. IP address = ");   Serial.println(WiFi.localIP());  

 
  // start a server
  server.begin();
  Serial.println("Server started");

  // start the websocket
  webSocket.begin();
  Serial.println("websocket started");

  Serial.println("");
  Serial.println("");

  // webSocketEvent is the function to call when there is a websocket event
  webSocket.onEvent(webSocketEvent);
 
}
 
 
void loop()
{
    // check the websocket status.
    webSocket.loop();

    // Check if a client has connected
    WiFiClient client = server.available();     

    // if a client has connected send the webpage
    if (client)  
    {  
        client.flush();
        client.print( header );
        client.print( html_1 ); 
        Serial.println("New page served");
        Serial.println("");
    }


    // see if it is time to update the sensor values on the website
    timeNow = millis();
    if (timeNow - timePrev >= sensorUpdateFrequency) 
    { 
      timePrev = timeNow;

      // if it is time, call the updateSensors() function 
      updateSensors(); 
    }

}  // void loop()



void updateSensors()
{
    brightness = map(analogRead(pinLDR), 0, 1023, 0, 12);
    //brightness = analogRead(pinLDR);
    humidity =   dht.readHumidity();        
    tempC =      dht.readTemperature();      // Read temperature as Celsius 
    tempF =      dht.readTemperature(true);  // Read temperature as Fahrenheit (isFahrenheit = true)

    //if any value is isnan (not a number) then there is an error
    if (isnan(humidity) || isnan(tempC) || isnan(tempF))        
    { 
       Serial.println("Error reading from the DHT11."); 
    }
   else
   {
      switchPinState = digitalRead(pinSWITCH);
      String whichTemp = "";
      if (switchPinState==true) {whichTemp = "F";} else {whichTemp = "C";}
       
      String data = "";
      data = String(data + byte(humidity) ); 
      data = String(data + "|"); 
      data = String(data + tempC); 
      data = String(data + "|"); 
      data = String(data + tempF); 
      data = String(data + "|"); 
      data = String(data + brightness); 
      data = String(data + "|"); 
      data = String(data + whichTemp); 
              
      webSocket.broadcastTXT(data); // send the data
      Serial.println(data);         // display the data in the serial monitor

      lcd.setCursor(0, 0);  lcd.print("ESP8266: IOT Monitor");
      lcd.setCursor(0, 1);  lcd.print("Temperature:        ");
      lcd.setCursor(0, 2);  lcd.print("Humidity:           ");
      lcd.setCursor(0, 3);  lcd.print("Brightness:         ");

      if (whichTemp =="C") 
      { 
         lcd.setCursor(13, 1); lcd.print(tempC); lcd.write(223);  lcd.print("C"); 
      }
      else                          
      { 
         if ( tempF < 100 ) { lcd.setCursor(13, 1); } else { lcd.setCursor(12, 1); }
         lcd.print(tempF);  lcd.write(223);  lcd.print("F"); 
      }

      lcd.setCursor(13, 2); lcd.print(humidity);   lcd.print("%");  
      lcd.setCursor(13, 3); lcd.print(brightness);
  }


  
} // void updateSensors()



// webSocketEvent is called when there is a websocket event
void webSocketEvent(byte num, WStype_t type, uint8_t * payload, size_t length)
{
    Serial.println("");
    Serial.print("WStype = ");   Serial.println(type);  
    Serial.print("WS payload = ");
    for(int i = 0; i < length; i++) { Serial.print((char) payload[i]); }
    Serial.println();
}
 
