//
//  ESP8266 and the Arduino IDE Part 10: Environment monitor station
//  ESP8266-10_sketch04_IOT_Website
//

String header = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";
String html_1 = R"=="==( 
<?xml version='1.0' encoding='utf-8'?>
<!DOCTYPE html PUBLIC '-//w3c//dtd xhtml 1.0 strict//en' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
  <head>
    <meta content='text/html;charset=utf-8' http-equiv='Content-Type'>
    <title>
      IOT TEST
    </title>
      
    <style>
      body           { background-color: #ffffff; font-size: 100% }
      #wrapper       { width: 500px; margin: 20px auto;  padding: 5px 5px 5px 5px;    text-align:center;   border: 2px solid blue;   border-radius: 15px;  }
      h2             { text-align: center;}
      h3             { margin: 0px 0px 5px 0px; }
      
      #topContainer  { display: flex; align-items: center;  justify-content: center;   Margin: 0px auto 2em auto;}
      #topContainer2 { text-align: center;  margin-right: 2em;  }
      #time          { display: inline; font-family: 'Courier New', Courier, monospace;  font-size: 250%;   }
      
      #dialContainer { display:inline-block;   margin: 0px auto 0px auto;  }
      #dial_1        { display:inline-block;  }
      #dial_2        { display:inline-block; margin: 0px 0px 0px 30px; }
      canvas         { background-color: #ffffff;    }
      .bigText       { font-size: 150%;}  
      .noMargin      { margin: 0px 0px 0px 0px; }
      
      #graphContainer { display:inline-block;  text-align:left; margin: 20px 0px 20px 0px;  }
      #key            { width: 200px;} 
      .box            { float: left;  height:15px;  width:10px;  margin: 0px 10px 0px 0px; clear: both;     }
      .red            { background-color: red; }
      .blue           { background-color: blue; }
    </style>
      
  </head>
  
  <body >
      <div id='wrapper'>
      
        <h1>Temperature & Humidity</h1>
  
        <div id='topContainer'>
            <div id='topContainer2'>
            <div id='brightnessIcon'></div>
            <div id='label'>Brightness</div>
          </div>
          <span id='time'>00:00:00</span>
        </div>

         <div id='dialContainer'> 
           <div id='dial_1'> 
             <h3>Temperature</h3>
             <canvas id='canvasTemp' width='200' height='150'  style='border:1px solid #000000;' > </canvas>
             <p class='noMargin bigText'><span id='temp'>00</span> °C</p>
           </div>    
  
           <div id='dial_2'> 
             <h3>Humidity</h3>
             <canvas id='canvasHumid' width='200' height='150'  style='border:1px solid #000000;' > </canvas>
             <p class='noMargin bigText'><span id='humd'>00</span> %</p>
           </div>
         </div>  <!--  'dialContainer'  -->
       
         <div id='graphContainer'> 
           <canvas id='graph' width='440' height='150'  style='border:1px solid #000000; background-color:white;' > </canvas>
           <div id='key'>
             <div> <div class='box red'></div> Temperature</div>
             <div> <div class='box blue'></div> Humidity</div>
           </div>   
         </div>      
      
      </div> <!--  'wrapper'  -->
  </body>
  
  <script type='text/javascript'>
  // <![CDATA[
  
  function updateValues(h,t,b)
  {
 
    drawSVG(b);
    drawDial('canvasTemp',  '#ffaaaa', 160, 20, -30,  50, t); 
    drawDial('canvasHumid', '#aaaaff', 160, 20,   0, 100, h);
    document.getElementById('temp').innerHTML = t;
    document.getElementById('humd').innerHTML = h;

    var graphCanvas = 'graph';
    var graphMin = -30;
    var graphMax = 100;
    var drawLines = true;
    drawGraph(graphCanvas, graphMin, graphMax, drawLines, t, h);
  }
  
  
  
  // ===========================================  DIAL  =========================================
  
  function drawDial(canvasID, dialColour, startAngle, stopAngle, minVal, maxVal, dialValue)
  {
    oneDegreeInRadians = Math.PI/180;
    if (stopAngle < startAngle) { stopAngle = stopAngle + 360;}

    let arcStartAngleInRadians =  oneDegreeInRadians * (startAngle-5)  ;
    let arcStopAngleInRadians  =  oneDegreeInRadians * (stopAngle+5) ;  

    var c = document.getElementById(canvasID);
    var ctx = c.getContext('2d');
    ctx.clearRect(0, 0, c.width, c.height);
    ctx.save();
    
    let H = c.height;
    let W = c.width;
    
    let arcLineWidth = W/5;
    ctx.translate(W/2, W/2);        // move coordinates 0,0 to the centre of the canvas
    
    // draw arc
    ctx.beginPath();
    let radius = W/2 - (arcLineWidth/2) - (W/100);      
    ctx.lineWidth = arcLineWidth;
    ctx.lineCap = 'butt';
    ctx.strokeStyle = dialColour;
    ctx.arc(0, 0, radius, arcStartAngleInRadians, arcStopAngleInRadians, false);
    ctx.stroke();

    
    // draw centre circle
    ctx.beginPath();
    let centerCircleRadius = W/100*3.5
    ctx.strokeStyle = '#000000';
    ctx.fillStyle = '#222222';
    ctx.lineWidth = 2;
    ctx.arc(0, 0, centerCircleRadius, 0, 2 * Math.PI, true);
    ctx.stroke();
    ctx.fill();
    

    // draw ticks 
    ctx.beginPath();
    ctx.lineWidth = 1;
    ctx.lineCap = 'butt';
    ctx.strokeStyle = '#333333';
  
    ctx.font = '12px Arial';
    ctx.fillStyle = '#333333';
    ctx.textAlign = 'center'; 
    ctx.textBaseline = 'top'; 

    let tickStartPoint = radius - (arcLineWidth/2) ;   // bottom of the arc
    let tickLength =  5/8 * arcLineWidth - 5; 
    
    let labelPos = radius + (arcLineWidth/2) - 2; 

    for (let angle=minVal; angle<=maxVal; angle = angle+10)
    {   
      let angleInDegrees =  (angle-minVal) *  ((stopAngle - startAngle) / (maxVal - minVal)) + startAngle  ;
      let angleInRadians = angleInDegrees * oneDegreeInRadians;

      ctx.rotate(angleInRadians );  
      ctx.moveTo(tickStartPoint, 0 );                   
      ctx.lineTo(tickStartPoint + tickLength, 0 );
      ctx.stroke();
      
      // draw the label at the right angle.
      // rotate the dial - 90 degree, draw the text at the new top of the dial, then rotate +90.
      // this means we use the - y axis.
      
      ctx.rotate(90*oneDegreeInRadians); 
      ctx.fillText(angle.toString(), 0, -labelPos );        
      ctx.rotate(-90*oneDegreeInRadians); 
      
      ctx.rotate(-angleInRadians);  //  this puts the dial back where it was.     
    }
  

    // draw the pointer
    
    // map the value to a degree
    let pointerAngleInDegrees =  (dialValue-minVal) *  ((stopAngle - startAngle) / (maxVal - minVal)) + startAngle  ;
    let pointerAngleInRadians = pointerAngleInDegrees * oneDegreeInRadians;

    let pointerLength = radius*0.86;
    let pointerWidth = W/100 * 2; 
    
    ctx.beginPath();
    ctx.lineWidth = pointerWidth;
    ctx.lineCap = 'round';  
    ctx.moveTo(0,0);
    ctx.rotate(pointerAngleInRadians);
    ctx.lineTo(pointerLength, 0);
    ctx.stroke();
    ctx.rotate(-pointerAngleInRadians);
  
    // reset the coordinates ready for next time    
    ctx.restore();
    
  }
  
  
  
  
  function drawGraph(canvasID, gMin, gMax, drawLines, t,h )
  {

    // Graph Init - draw the graph but do not draw values.
  
    var c = document.getElementById(canvasID);
    var ctx = c.getContext('2d');
    ctx.clearRect(0, 0, c.width, c.height); 

    var graphWidth  = c.width;
    var graphHeight = c.height; 
      
    var fontSize = '10px Arial';
    var fontAdjust = 3;
    if (graphHeight < 100) { fontSize = '6px Arial'; fontAdjust = 1;}
    
    var numySteps = gMax - gMin;
    if (numySteps > 10) { numySteps = numySteps /10; }
    var numxSteps = 20;

    var xStep = graphWidth / numxSteps;
    var yStep = graphHeight / numySteps;

  
    ctx.lineWidth = 1;
    ctx.strokeStyle = '#e5e5e5';
    ctx.lineCap = 'butt';
        for (let x = 0; x < c.width; x=x+xStep) 
    { 
       ctx.moveTo(x, 0);    ctx.lineTo(x, c.height);     ctx.stroke();
    }

        for (let y = 0; y <= numySteps; y++) 
    { 
       let yPos = y * yStep;
       ctx.moveTo(0, yPos);    ctx.lineTo(c.width,yPos);    ctx.stroke();
    }
    
    // draw labels    
    ctx.font = fontSize;
    ctx.fillStyle = '#000000';
     
    // no need to draw the first or the last label
    for (let i = 1; i < numySteps; i++)
    {
         let yPos = c.height - i * yStep;
         let tmp = i * 10;
         tmp = tmp + gMin;
         let txt = tmp.toString();
         ctx.fillText(txt, 2, yPos + fontAdjust);        
    }
  
    
    // draw the  values on the graph  
    if (drawLines)
    {
        tempArray.shift();  tempArray[19] = t;
        humdArray.shift();  humdArray[19] = h;
    
        // Temperature        
        ctx.beginPath();
        ctx.lineWidth = 1;  
        ctx.strokeStyle = '#ff7777';  
        ctx.fillStyle   = '#ff4444';  
    
        // on the first value we are not coming from an existing point so we just need to move to the coordinates ready to plot value 2.
        let firstValue = true;

        for (let i = 0; i < numxSteps; i++) 
        { 
            if (tempArray[i] != -9999) 
            {
                let tmpVal = tempArray[i] ;
                let yPos = (tmpVal - gMin) * (graphHeight - 0)/( gMax - gMin ) + 0;
                yPos = graphHeight - yPos;
                let xPos = (i*xStep) + xStep;
                
                // draw the line
                if (firstValue)   {  ctx.moveTo(xPos, yPos);  firstValue = false;  }
                else              {  ctx.lineTo(xPos,yPos);   ctx.stroke();  }
            
                // draw the dot
                ctx.beginPath();  ctx.arc(xPos, yPos, 3, 0, 2 * Math.PI, false);  ctx.fill();
            }
        }

      
        // Humidity
        ctx.lineWidth = 1;  
        ctx.strokeStyle = '#7777ff';  
        ctx.fillStyle   = '#4444ff';    
        ctx.beginPath();
    
        // on the first value we are not coming from an existing point so we just need to move to the coordinates ready to plot value 2.
        firstValue = true;
  
        for (let i = 0; i < numxSteps; i++) 
        { 
            if (humdArray[i] != -9999) 
            {
                let tmpVal = humdArray[i] ;
                let yPos = (tmpVal - gMin) * (graphHeight - 0)/( gMax - gMin ) + 0;
                yPos = graphHeight - yPos;
                let xPos = (i*xStep) + xStep;
                
                // draw the line
                if (firstValue)   {  ctx.moveTo(xPos, yPos);  firstValue = false;  }
                else              {  ctx.lineTo(xPos,yPos);   ctx.stroke();  }
      
                // draw the dot
                ctx.beginPath();  ctx.arc(xPos, yPos, 3, 0, 2 * Math.PI, false);  ctx.fill();
            }
        }

    } // if (! initOnly)
  } // function drawGraph
  
  
  function drawSVG(brightnessVal)
  {
    // create the sun icon
    // the number of rays represents the brightness value from 0 to 12

    // when adding the actual value to the graphic, this updates the value. When the text part is not used it has no affect.
    var SVGicon = svgArray[0].replace('[bright]', brightnessVal);
    for (var i=1; i <= brightnessVal; i++)  { SVGicon = SVGicon + svgArray[i];  }
    document.getElementById('brightnessIcon').innerHTML = SVGicon;
  }
  

  function processReceivedData(evt) 
  {
    var data = evt.data;
    console.log(data);

    var tmp = data.split('|');

    // convert the received string in to numbers
    var h = parseInt(tmp[0]);
    var t = parseInt(tmp[1]);
    var b = parseInt(tmp[3]);
    updateValues(h,t,b);
  }


  function updateTime() 
  {  
     var d = new Date();
     var t = d.toLocaleTimeString();
     document.getElementById('time').innerHTML = t;
  }

  // This is executed after the document has finished loading.
  function init() 
  {
    Socket = new WebSocket('ws://' + window.location.hostname + ':81/');
    Socket.onmessage = function(event) { processReceivedData(event); };
    
    console.log('started');
    drawDial('canvasTemp',  '#ffaaaa', 160, 20, -30,  50, 0); 
    drawDial('canvasHumid', '#aaaaff', 160, 20,   0, 100, 0);
    drawGraph('graph', -30, 100, false, t, h);
    drawSVG(0);
    
    var myVarTime = setInterval(updateTime, 1000); 
  }

  
  // arrays to hold the temperature and humidity values.
  var tempArray = [ -9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999 ];
  var humdArray = [ -9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999,-9999 ];

  var t = -30;
  var h = 0;
  var b = 0;

  // arrays to hold the svg data for the sun icon
  var svgArray = [];
  svgArray[0] = "<?xml version='1.0' encoding='UTF-8'?> <!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.1//EN' 'http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd'> <svg xmlns='http://www.w3.org/2000/svg' xml:space='preserve' width='25mm' height='25mm' version='1.1' viewBox='0 0 2500 2500'   xmlns:xlink='http://www.w3.org/1999/xlink'> <defs> <style type='text/css'> <![CDATA[ .str0 {stroke:#aaaaaa; stroke-width:20.00} .str1 {stroke:#aaaaaa; stroke-width:7.5} .str2 {stroke:#aaaaaa; stroke-width:15.00} .fil0 {fill:black} .fil1 {fill:yellow} .fnt0 {font-weight:normal;font-size:400px;font-family:'Verdana'} ]]> </style> </defs> <g id='Layer_x0020_1'> <circle class='fil1 str2' cx='1250' cy='1250' r='680'/>";
  //svgArray[0] = svgArray[0] + "<text x='50%' y='50%' dominant-baseline='middle' text-anchor='middle' class='fil0 fnt0'>[bright]</text>";
  svgArray[1] = "<rect class='fil1 str0' transform='matrix(0.133299 -0.23088 0.246464 0.142296 1562.82 538.757)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[2] = "<rect class='fil1 str0' transform='matrix(0.23088 -0.133299 0.142296 0.246464 1876.53 790.456)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[3] = "<rect class='fil1 str1' x='2022' y='1165' width='428' height='169' rx='75' ry='80'/>";
  svgArray[4] = "<rect class='fil1 str0' transform='matrix(-0.23088 -0.133299 0.142296 -0.246464 2246.87 1923.36)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[5] = "<rect class='fil1 str0' transform='matrix(-0.133299 -0.23088 0.246464 -0.142296 1776.64 2331.58)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[6] = "<rect class='fil1 str0' transform='matrix(-2.11373E-014 0.266598 -0.284592 -2.25059E-014 1334.71 2022.37)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[7] = "<rect class='fil1 str0' transform='matrix(0.133299 -0.23088 0.246464 0.142296 576.632 2246.88)' width='1604' height='595' rx='280' ry='280'/> ";
  svgArray[8] = "<rect class='fil1 str0' transform='matrix(0.23088 -0.133299 0.142296 0.246464 168.409 1776.64)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[9] = "<rect class='fil1 str1' x='50' y='1165' width='428' height='169' rx='75' ry='80'/>";
  svgArray[10] = "<rect class='fil1 str0' transform='matrix(-0.23088 -0.133299 0.142296 -0.246464 538.753 937.178)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[11] = "<rect class='fil1 str0' transform='matrix(-0.133299 -0.23088 0.246464 -0.142296 790.452 623.465)' width='1604' height='595' rx='280' ry='280'/>";
  svgArray[12] = "<rect class='fil1 str0' transform='matrix(-2.11373E-014 0.266598 -0.284592 -2.25059E-014 1334.71 50.0007)' width='1604' height='595' rx='280' ry='280'/>";

  
  document.addEventListener('DOMContentLoaded', init, false);
  
 
  // ]]>
  </script>
  
  
</html> 
)=="==";





#include <ESP8266WiFi.h>
#include <WebSocketsServer.h>
 
WiFiServer server(80);
WebSocketsServer webSocket = WebSocketsServer(81);

char ssid[] = "mySSID";
char pass[]= "myPassword";


#include "DHT.h"
#define DHTPIN D6     
#define DHTTYPE DHT11   
DHT dht(DHTPIN, DHTTYPE);

byte const pinLED = D5;
byte const pinLDR = A0;

int brightness = 0;
float humidity = 0;       
float tempC = 0;
float tempF = 0;

boolean DHTreadingsOK = false;
boolean updateWebpage = false;

long sensorUpdateFrequency = 5000;
long timeNow = 0;
long timePrev = 0;

 
void setup()
{
  pinMode(pinLED, OUTPUT); digitalWrite(pinLED, LOW); 
  dht.begin();
  
  Serial.begin(9600);
  while (!Serial) {;}
  Serial.println();
  Serial.println("Serial started at 9600");
  Serial.println();
 
  // Connect to a WiFi network
  Serial.print("Connecting to ");  Serial.println(ssid); 
  
  // try to connect to the network
  WiFi.begin(ssid,pass);
  
  // connection with timeout
  int count = 0; 
  digitalWrite(pinLED, HIGH); 
  while ( (WiFi.status() != WL_CONNECTED) && count < 17) 
  {
      Serial.print(".");    count++;     delay(500);
  }
 digitalWrite(pinLED, LOW);
 
  if (WiFi.status() != WL_CONNECTED)
  { 
     Serial.println("");  Serial.print("Failed to connect to ");  Serial.println(ssid);
     while(1);
  }
 
  Serial.println("");
  Serial.print("Connected. IP address = ");   Serial.println(WiFi.localIP());  

 
  // start a server
  server.begin();
  Serial.println("Server started");

  // start the websocket
  webSocket.begin();
  Serial.println("websocket started");

  Serial.println("");
  Serial.println("");

  // webSocketEvent is the function to call when there is a websocket event
  webSocket.onEvent(webSocketEvent);
 
}
 
 
void loop()
{
    // check the websocket status.
    webSocket.loop();

    // Check if a client has connected
    WiFiClient client = server.available();     

    // if a client has connected send the webpage
    if (client)  
    {  
        client.flush();
        client.print( header );
        client.print( html_1 ); 
        Serial.println("New page served");
        Serial.println("");
        updateSensors();
    }


    // see if it is time to update the sensor values on the website
    timeNow = millis();
    if (timeNow - timePrev >= sensorUpdateFrequency) 
    { 
      timePrev = timeNow;

      // if it is time, call the updateSensors() function 
      updateSensors(); 
    }

}  // void loop()



void updateSensors()
{
    brightness = map(analogRead(pinLDR), 0, 1023, 0, 12);
    //brightness = analogRead(pinLDR);
    humidity =   dht.readHumidity();        
    tempC =      dht.readTemperature();      // Read temperature as Celsius 
    tempF =      dht.readTemperature(true);  // Read temperature as Fahrenheit (isFahrenheit = true)

    //if any value is isnan (not a number) then there is an error
    if (isnan(humidity) || isnan(tempC) || isnan(tempF))        
    { 
       Serial.println("Error reading from the DHT11."); 
    }
   else
   {
      String data = "";
      data = String(data + byte(humidity) ); 
      data = String(data + "|"); 
      data = String(data + tempC); 
      data = String(data + "|"); 
      data = String(data + tempF); 
      data = String(data + "|"); 
      data = String(data + brightness); 
              
      webSocket.broadcastTXT(data); // send the data
      Serial.println(data);         // display the data in the serial monitor
  
      // blink the status LED to show data has been sent
      digitalWrite(pinLED, HIGH);   delay(50);  digitalWrite(pinLED, LOW);
  }
  
} // void updateSensors()



// webSocketEvent is called when there is a websocket event
void webSocketEvent(byte num, WStype_t type, uint8_t * payload, size_t length)
{
    Serial.println("");
    Serial.print("WStype = ");   Serial.println(type);  
    Serial.print("WS payload = ");
    for(int i = 0; i < length; i++) { Serial.print((char) payload[i]); }
    Serial.println();
}
 
