/*
 * Sketch: ESP8266_LED_CONTROL_AJAX_06
 * Intended to be run on an ESP8266
 * 
 * Uses Station Mode on the ESP8266
 */
 
String header = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";

String html_1 = R"=====(
<!DOCTYPE html>
<html>
 <head>
 <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
 <meta charset='utf-8'>
 <style>
  body {font-size:140%; } 
  #main {display: table; margin: auto;  padding: 0 5px 0 5px;  } 
  h2 {text-align:center; } 
  #LED_button { width: 4em;  background-color: #FF5050; font-size: 120%; }
  table {width: 100%; }
 </style>

<script>
  function switchLED() 
  {
     var button_text = document.getElementById("LED_button").value;
     if (button_text=="OFF")
     {
       document.getElementById("LED_button").value = "ON";
       document.getElementById("LED_button").style.background = "#50FF50";
       ajaxLoad('L11'); 
     }
     else
     {
       document.getElementById("LED_button").value = "OFF";
       document.getElementById("LED_button").style.background = "#FF5050";
       ajaxLoad('L10');
     }
    }

var ajaxRequest = null;
if (window.XMLHttpRequest)  { ajaxRequest =new XMLHttpRequest(); }
else                        { ajaxRequest =new ActiveXObject("Microsoft.XMLHTTP"); }


function ajaxLoad(ajaxURL)
{
  if(!ajaxRequest){ alert("AJAX is not supported."); return; }
  
  ajaxRequest.open("GET",ajaxURL,true);
  ajaxRequest.onreadystatechange = function()
  {
    if(ajaxRequest.readyState == 4 && ajaxRequest.status==200)
    {
      var ajaxResult = ajaxRequest.responseText;
    }
  }
  ajaxRequest.send();
}
   
</script>

 <title>LED Control</title>
</head>
<body>
 <div id='main'>
  <h2>LED Control</h2>
  <table id = "controls">
  <tr>
  <td width="70%">LED 1</td>
)=====";


String html_2 = R"=====(
  <td> <input type='button' id = 'LED_button'  onclick='switchLED()' value='OFF'  />  </td>
)=====";


String html_4 = R"=====(
  </tr>
  </table>
 </div>
</body>
</html>
)=====";


#include <ESP8266WiFi.h>

// change these values to match your network
char ssid[] = "NetworkName";       //  your network SSID (name)
char pass[] = "password";            //  your network password
 
WiFiServer server(80);

 
String request = "";
int LED_Pin = D1;

 
void setup() 
{
    pinMode(LED_Pin, OUTPUT);     
    
    Serial.begin(115200);
    Serial.println();
    Serial.println("Serial started at 115200");
    Serial.println("ESP8266_LED_CONTROL_AJAX_06");
    Serial.println();
 
    // Connect to a WiFi network
    Serial.print(F("Connecting to "));  Serial.println(ssid);
    WiFi.begin(ssid, pass);
 
    while (WiFi.status() != WL_CONNECTED) 
    {
        Serial.print(".");
        delay(500);
    }
      
    Serial.println("");
    Serial.println(F("[CONNECTED]"));
    Serial.print("[IP ");              
    Serial.print(WiFi.localIP()); 
    Serial.println("]");
 
    // start a server
    server.begin();
    Serial.println("Server started");
 
} // void setup()
 
 
 
void loop() 
{
    // Check if a client has connected
    WiFiClient client = server.available();
    if (!client)  {  return;  }
 
    // Read the first line of the request
    request = client.readStringUntil('\r');

    Serial.print("request: "); Serial.println(request); 
 
    if       ( request.indexOf("L11") > 0 )  { digitalWrite(LED_Pin, HIGH);  }
    else if  ( request.indexOf("L10") > 0 )  { digitalWrite(LED_Pin, LOW);   }
    else
    {
        boolean pinStatus = digitalRead(LED_Pin);
        if (pinStatus==HIGH) { html_2.replace( "value='OFF'" , "value='ON'" );  
                               html_1.replace( "background-color: #FF5050;" , "background-color: #50FF50;" ); 
                             }
        else                 { html_2.replace( "value='ON'" , "value='OFF'" );   
                               html_1.replace( "background-color: #50FF50;" , "background-color: #FF5050;" ); 
                             }
        
        client.flush();
        client.print( header );
        client.print( html_1 );    
        client.print( html_2 );  
        client.print( html_4 );  
       
        delay(5);
    }


  
  // The client will actually be disconnected when the function returns and 'client' object is detroyed
} // void loop()

