/*
 * Sketch: ESP8266_LED_CONTROL_AJAX_07
 * Intended to be run on an ESP8266
 */
 
String header = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";

String html_1 = R"=====(
<!DOCTYPE html>
<html>
 <head>
 <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
 <meta charset='utf-8'>
 <style>
  body {font-size:140%; } 
  #main {display: table; margin: auto;  padding: 0 5px 0 5px;  } 
  h2 {text-align:center; } 
  input[type="button"] { width: 4em; font-size: 120%; }
  .green { background-color: #50FF50;  }
  .red   { background-color: #FF5050;  }  
  table {width: 100%; }
 </style>

<script>
  function switchLED1() 
  {
     var button_text = document.getElementById("LED1_button").value;
     if (button_text=="OFF")
     {
       document.getElementById("LED1_button").value = "ON";
       document.getElementById("LED1_button").style.background = "#50FF50";
       ajaxLoad('L11'); 
     }
     else
     {
       document.getElementById("LED1_button").value = "OFF";
       document.getElementById("LED1_button").style.background = "#FF5050";
       ajaxLoad('L10');
     }
  }

  function switchLED2() 
  {
     var button_text = document.getElementById("LED2_button").value;
     if (button_text=="OFF")
     {
       document.getElementById("LED2_button").value = "ON";
       document.getElementById("LED2_button").style.background = "#50FF50";
       ajaxLoad('L21'); 
     }
     else
     {
       document.getElementById("LED2_button").value = "OFF";
       document.getElementById("LED2_button").style.background = "#FF5050";
       ajaxLoad('L20');
     }
  }

  function switchLED3() 
  {
     var button_text = document.getElementById("LED3_button").value;
     if (button_text=="OFF")
     {
       document.getElementById("LED3_button").value = "ON";
       document.getElementById("LED3_button").style.background = "#50FF50";
       ajaxLoad('L31'); 
     }
     else
     {
       document.getElementById("LED3_button").value = "OFF";
       document.getElementById("LED3_button").style.background = "#FF5050";
       ajaxLoad('L30');
     }
  }  

  var ajaxRequest = null;
  if (window.XMLHttpRequest)  { ajaxRequest =new XMLHttpRequest(); }
  else                        { ajaxRequest =new ActiveXObject("Microsoft.XMLHTTP"); }


  function ajaxLoad(ajaxURL)
  {
    if(!ajaxRequest){ alert("AJAX is not supported."); return; }
    
    ajaxRequest.open("GET",ajaxURL,true);
    ajaxRequest.onreadystatechange = function()
    {
      if(ajaxRequest.readyState == 4 && ajaxRequest.status==200)
      {
        var ajaxResult = ajaxRequest.responseText;
      }
    }
    ajaxRequest.send();
  }
   
</script>

 <title>LED Control</title>
</head>
<body>
 <div id='main'>
  <h2>LED Control</h2>
  <table id = "controls">
   <tr>
    <td width="70%">LED 1</td>
)=====";

String html_2 = "    <td> <input type='button' id='LED1_button' value='OFF' class='red' onclick='switchLED1()' />  </td>";

String html_3 = R"=====(
   </tr>
   <tr>
    <td width="70%">LED 2</td>
)=====";

String html_4 = "    <td> <input type='button' id='LED2_button' value='OFF' class='red' onclick='switchLED2()' />  </td>";

String html_5 = R"=====(
   </tr>
   <tr>
    <td width="70%">LED 3</td>
)=====";    

String html_6 = "    <td> <input type='button' id='LED3_button' value='OFF' class='red' onclick='switchLED3()' />  </td>";

String html_7 = R"=====(
   </tr>
  </table>
 </div>
</body>
</html>
 
)=====";



#include <ESP8266WiFi.h>

// change these values to match your network
char ssid[] = "NetworkName";       //  your network SSID (name)
char pass[] = "password";            //  your network password
 
WiFiServer server(80);

 
String request = "";
int LED1_Pin = D1;
int LED2_Pin = D2;
int LED3_Pin = D3;
 
void setup() 
{
    pinMode(LED1_Pin, OUTPUT);     
    pinMode(LED2_Pin, OUTPUT);  
    pinMode(LED3_Pin, OUTPUT);  
  
    Serial.begin(115200);
    Serial.println();
    Serial.println("Serial started at 115200");
    Serial.println("ESP8266_LED_CONTROL_AJAX_07");
    Serial.println();
 
    // Connect to a WiFi network
    Serial.print(F("Connecting to "));  Serial.println(ssid);
    WiFi.begin(ssid, pass);
 
    while (WiFi.status() != WL_CONNECTED) 
    {
        Serial.print(".");
        delay(500);
    }
      
    Serial.println("");
    Serial.println(F("[CONNECTED]"));
    Serial.print("[IP ");              
    Serial.print(WiFi.localIP()); 
    Serial.println("]");
 
    // start a server
    server.begin();
    Serial.println("Server started");
 
} // void setup()
 
 
 
void loop() 
{
    // Check if a client has connected
    WiFiClient client = server.available();
    if (!client)  {  return;  }
 
    // Read the first line of the request
    request = client.readStringUntil('\r');

    Serial.print("request: "); Serial.println(request); 
 
    if       ( request.indexOf("L11") > 0 )  { digitalWrite(LED1_Pin, HIGH);  }
    else if  ( request.indexOf("L10") > 0 )  { digitalWrite(LED1_Pin, LOW);   }
    if       ( request.indexOf("L21") > 0 )  { digitalWrite(LED2_Pin, HIGH);  }
    else if  ( request.indexOf("L20") > 0 )  { digitalWrite(LED2_Pin, LOW);   }
    if       ( request.indexOf("L31") > 0 )  { digitalWrite(LED3_Pin, HIGH);  }
    else if  ( request.indexOf("L30") > 0 )  { digitalWrite(LED3_Pin, LOW);   }
    else
    {
       if (digitalRead(LED1_Pin)==HIGH) 
       { 
         html_2 = "    <td> <input type='button' id='LED1_button' value='ON' class='green' onclick='switchLED1()' />  </td>";
       }
       else
       {
         html_2 = "    <td> <input type='button' id='LED1_button' value='OFF' class='red' onclick='switchLED1()' />  </td>";
       }

       
       if (digitalRead(LED2_Pin)==HIGH) 
       { 
         html_4 = "    <td> <input type='button' id='LED2_button' value='ON' class='green' onclick='switchLED2()' />  </td>";
       }
              else
       {
         html_4 = "    <td> <input type='button' id='LED2_button' value='OFF' class='red' onclick='switchLED2()' />  </td>";
       }


       if (digitalRead(LED3_Pin)==HIGH) 
       { 
         html_6 = "    <td> <input type='button' id='LED3_button' value='ON' class='green' onclick='switchLED3()' />  </td>";
       }
       else
       {
         html_6 = "    <td> <input type='button' id='LED3_button' value='OFF' class='red' onclick='switchLED3()' />  </td>";
       }

        client.flush();
        client.print( header );
        client.print( html_1 );    
        client.print( html_2 ); 
        client.print( html_3 ); 
        client.print( html_4 ); 
        client.print( html_5 ); 
        client.print( html_6 ); 
        client.print( html_7 ); 
        delay(5);
    }
 
  
  // The client will actually be disconnected when the function returns and 'client' object is detroyed
} // void loop()
