//  Arduino, HM-10, App Inventor 2
//
//  Example Project Part 4: Complex control codes II
//  By Martyn Currey. www.martyncurrey.com
//
//  Pins
//  BT VCC to Arduino 5V out. 
//  BT GND to GND
//  Arduino D8 (ASS RX) - BT TX no need voltage divider 
//  Arduino D9 (ASS TX) - BT RX through a voltage divider
//  Arduino D2 - Resistor + LED
//  Arduino D3 - 10K pull down resistor + button switch



// AltSoftSerial uses D9 for TX and D8 for RX. While using AltSoftSerial D10 cannot be used for PWM.
// Remember to use a voltage divider on the Arduino TX pin / Bluetooth RX pin
// Download from https://www.pjrc.com/teensy/td_libs_AltSoftSerial.html

#include <AltSoftSerial.h>
AltSoftSerial ASSserial; 
 

// Variables used for incoming data
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newCommand = false;

// Constants for hardware
const byte LEDPin = 2;
const byte SwitchPin = 3;

// general variables
boolean LED_State = false;
boolean switch_State = false;
boolean oldswitch_State = false;

void setup()  
{
    Serial.begin(9600);
    Serial.print("Sketch:   ");   Serial.println(__FILE__);
    Serial.print("Uploaded: ");   Serial.println(__DATE__);
    Serial.println(" ");
     
    ASSserial.begin(9600); 
    Serial.println("AltSoftSerial started at 9600"); 
    Serial.println(" ");

    pinMode(LEDPin, OUTPUT); 
    digitalWrite(LEDPin,LOW);

    pinMode(SwitchPin, INPUT); 
    
          
} // void setup()
 
 
void loop()  
{
       checkSwitch();
       recvWithStartEndMarkers();                // check to see if we have received any new commands
       if (newCommand)  {   processCommand();  }    // if we have a new command do something about it
}



/*
****************************************
* Function checkSwitch()
* checks the status of a button switch and turns an LED on or off depending on the switch status
* 
* passed:
*  
* global: 
*      switch1_State
*      LED1_State
*      oldswitch1_State
*
* Returns:
*          
* Sets:
*      switch1_State
*      LED1_State
*      oldswitch1_State
*/
void checkSwitch()
{
     // Simple toggle switch function with even simpler debounce.
     boolean state1 = digitalRead(SwitchPin); delay(1);
     boolean state2 = digitalRead(SwitchPin); delay(1);
     boolean state3 = digitalRead(SwitchPin); 
     if ((state1 == state2) && (state1==state3))   
     { 
          switch_State = state1;  
          if ( (switch_State == HIGH) && (oldswitch_State == LOW) )
          {
               LED_State = ! LED_State;  
               if ( LED_State == HIGH) 
               {  
                    ASSserial.print("[L,1,1]" );  
                    digitalWrite(LEDPin,HIGH);  
                    Serial.println("Sent - [L,1,1]");    
               }
                                           
               else                     
               {  
                   ASSserial.print("[L,1,0]");   
                   digitalWrite(LEDPin,LOW);   
                   Serial.println("Sent - [L,1,0]");    
               }    
          }          
          oldswitch_State = switch_State;
      }
}



/*
****************************************
* Function processCommand
* parses data commands contained in receivedChars[]
* receivedChars[] has not been checked for errors
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       receivedChars[]
*       newData
*/
void processCommand()
{

    // The LED command is 3 characters 
    // chr 1 = L for LED
    // chr 2 = 1 for the LED number
    // chr 3 = 0 or 1 for on/off

    if ( receivedChars[0] =='L')
    // do we have an LED command
    {
         if ( receivedChars[1]=='1' )
         // is it for LED #1
         {
              receivedChars[2] = receivedChars[2] -48;
              // subtracting 48 turns acsii in to actual values. "0" becomes 0 and "1" becomes 1.
              LED_State = receivedChars[2];
              digitalWrite(LEDPin,LED_State);
              Serial.print("LED1 state = "); Serial.println(LED_State);
         }
    }
    
 
    receivedChars[0] = '\0';
    newCommand = false;
   
}


// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the content between a start marker and an end marker.
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers()
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '[';
     char endMarker = ']';
     char rc;
 
     if (ASSserial.available() > 0) 
     {
          rc = ASSserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newCommand = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
}



 
 
































