//  Sketch: HM-10_Example_04A_RemoteLightSensor
//
//  Master HM-10
//  Pins
//  BT VCC to Arduino 5V out. 
//  BT GND to GND
//  Arduino D8 (ASS RX) - BT TX no need voltage divider 
//  Arduino D9 (ASS TX) - BT RX through a voltage divider
//
//  Remote HM-10
//  HM-10 vcc to +5V
//  HM-10 GND to GND
//  HM-10 PIOB to LDR/CDS

 
#include <AltSoftSerial.h>
AltSoftSerial BTSerial; 
 
char c=' ';
char reply[30];
int pos = 0;
 
void setup() 
{
    Serial.begin(9600);
    Serial.print("Sketch:   ");   Serial.println(__FILE__);
    Serial.print("Uploaded: ");   Serial.println(__DATE__);
    Serial.println(" ");

    Serial.println("The HM-10s should be set for auto connect");
    Serial.println("The remote HM-10 should be set for MODE1");
    
    BTSerial.begin(9600);  
    Serial.println("BTserial started at 9600");
    Serial.println(" ");
}
 
void loop()
{
    BTSerial.print("AT+ADCB?");
    delay(500);

    pos = 0;
    while ( BTSerial.available() )
    {
        c = BTSerial.read();
        reply[pos] = c;
        pos++;
    }
    reply[pos] = '\0';
    Serial.print("Reply = "); Serial.println(reply); 

    delay (3000);

}


 





