/*
* Sketch: BCP_Example04_Servo
* By Martyn Currey
* 17.09.2016
* Written in Arduino IDE 1.6.3
*
* Control a servo from a remote app
*
* Requires the  Bluetooth Control Panel Android App. Can be downloaded from Google Play.
* See http://www.martyncurrey.com/bluetooth-control-panel/

* Uses the following pins
* D3 - servo
* D8 - AltsoftSerial RX
* D9 - AltsoftSerial TX
*
*/


#include <AltSoftSerial.h>
AltSoftSerial BTserial; 

// ServoTimer2 library can be downloaded from https://github.com/nabontra/ServoTimer2 
// ServoTimer2 has a fairly high minimum pulse width and a fairly low maximum pilse width. These don't usually give full 180 degree movement.
// In the ServoTimer2.h file change the minimum and maximum pulse values:
// Change #define MIN_PULSE_WIDTH 750 to #define MIN_PULSE_WIDTH 500 
// Change #define MAX_PULSE_WIDTH 2250 to MAX_PULSE_WIDTH 2300

#include <ServoTimer2.h>  // the servo library
ServoTimer2 myservo;      // create a servo object

// The servo used in the example is at 0 degree when the pulse is 500 and at 180 degree (more like 178 degrees) when the pulse is 2300.
// Your servo is likely to be slightly different.
const int servoMaxPulse = 2300;
const int servoMinPulse = 500;


 
// Variables used for incoming data
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newData = false;
boolean initialized = false;

// Other vaiables 
unsigned long startTime = 0;
unsigned long flashStartTime = millis();
boolean LEDstate = LOW;


void setup()  
{
    // Set the onboard LED pin for output
    pinMode(13, OUTPUT); 
    digitalWrite(13,LOW);
    
    myservo.attach(3);
    myservo.write(servoMinPulse); 
     
    //  open software serial connection to the Bluetooth module.
    BTserial.begin(9600); 
          
    newData = false;
    initialized = false;
    startTime = millis();
  
} // void setup()
 
 

 
void loop()  
{
    if (!initialized)
    {
        if (  millis()-startTime > 250 ) 
        {
             startTime = millis();
             if (LEDstate == HIGH) { LEDstate = LOW;  digitalWrite(13,LOW);  }
             else                  { LEDstate = HIGH; digitalWrite(13,HIGH); }
        }
         recvWithStartEndMarkers();       
         if (newData)  
         {   
              if (strcmp ("CONNECT",receivedChars) == 0 or strcmp ("RESET",receivedChars) == 0) 
              { 
                   sendInitCommands();
              }
         }
     }
         

    
    if (initialized)
    {
       recvWithStartEndMarkers();                // check to see if we have received any new commands
       if (newData)  {   processCommand();  }    // if we have a new command do something about it
    }
}





/*
****************************************
* Function sendInitCommands
* Sends ascii initialization codes over BTserial
* 
* passed:
*  
* global: 
*       initialized
*
* Returns:
*          
* Sets:
*       initialized
*
*/
void sendInitCommands()
{ 

     BTserial.print("<T,Servo Control>");
     BTserial.print("<I,SL,1,Servo Position,0,180,255250230>");  
     BTserial.print("<EOI>");  
     delay(100);
     initialized = true;
     digitalWrite(13,HIGH);     
}


 

/*
****************************************
* Function processCommand
* parses data commands contained in receivedChars[]
* receivedChars[] has not been checked for errors
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*
*/
void processCommand()
{
     newData = false;

     if (strcmp ("RESET",receivedChars) == 0) 
     { 
          sendInitCommands();
     }
     
     else if (strcmp ("DISCONNECT",receivedChars) == 0) 
     { 
          initialized = false;
     }

    else if (receivedChars[0]== 'S' && receivedChars[1]== 'L')
    {
          unsigned int servoPulse = 0;
          int val =   (receivedChars[3]-48) *1000;
          val = val + (receivedChars[4]-48) * 100;
          val = val + (receivedChars[5]-48) *  10;
          val = val + (receivedChars[6]-48);    
          
          if ( receivedChars[2]== '1' )
          {
              // convert the slider range 0-180 to the servo pulse range of servoMinPulse-servoMaxPulse
              // the servo is right to left, the slider is left to right so use map to flip the value around
              servoPulse = map(val,180,0,servoMinPulse,servoMaxPulse);
              myservo.write(servoPulse);          
          }
    }

    receivedChars[0] = '\0';
    strcpy("",receivedChars ); 
   
}





// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the content between a start marker and an end marker.
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers()
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '<';
     char endMarker = '>';
     char rc;
 
     if (BTserial.available() > 0) 
     {
          rc = BTserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
 
}







 
 
































