/*
* Sketch: TWO_WAY_LED_CONTROL_1_LED
* By Martyn Currey
* 20.08.2016
* Written in Arduino IDE 1.6.3
*
* Requires the Arduino Bluetooth Control II Android App. Can be downloaded from Google Play.
* See http://www.martyncurrey.com/arduino-bluetooth-control/
*
* Turn an LED on and off from an Android app or from a physical switch connected to the Arduino
* Uses the following pins
*
* D8 - AltsoftSerial TX
* D9 - AltsoftSerial RX
* D5 - LED + resistor
* D2 - Button switch 
*/

// AltSoftSerial uses D9 for TX and D8 for RX. While using AltSoftSerial D10 cannot be used for PWM.
// Remember to use a voltage divider on the Arduino TX pin / Bluetooth RX pin
// Download from https://www.pjrc.com/teensy/td_libs_AltSoftSerial.html

#include <AltSoftSerial.h>
AltSoftSerial BTserial; 
 

// Variables used for incoming data
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newData = false;

// Constants for hardware
const byte LED1_PIN = 2;
const byte SWITCH1_PIN = 5;

// general variables
boolean LED1_State = false;
boolean switch1_State = false;
boolean oldswitch1_State = false;

void setup()  
{
    // Set the button switch pin for input
    pinMode(SWITCH1_PIN, INPUT); 

    // Set the red LED pin for output and make it LOW
    pinMode(LED1_PIN, OUTPUT); 
    digitalWrite(LED1_PIN,LOW);
     
    // open serial communication for debugging
    Serial.begin(9600);
    Serial.print("Sketch:   ");   Serial.println(__FILE__);
    Serial.print("Uploaded: ");   Serial.println(__DATE__);
    Serial.println(" ");
     
    //  open software serial connection to the Bluetooth module.
    BTserial.begin(9600); 
    Serial.println("AltSoftSerial started at 9600"); 
          
    newData = false;

} // void setup()
 
 
void loop()  
{
       checkSwitch();
       recvWithStartEndMarkers();                // check to see if we have received any new commands
       if (newData)  {   processCommand();  }    // if we have a new command do something about it
}



/*
****************************************
* Function checkSwitch()
* checks the status of a button switch and turns an LED on or off depending on the switch status
* 
* passed:
*  
* global: 
*      switch1_State
*      LED1_State
*      oldswitch1_State
*
* Returns:
*          
* Sets:
*      switch1_State
*      LED1_State
*      oldswitch1_State
*/
void checkSwitch()
{
     // Simple toggle switch function with very simple debouce.
     boolean state1 = digitalRead(SWITCH1_PIN); delay(1);
     boolean state2 = digitalRead(SWITCH1_PIN); delay(1);
     boolean state3 = digitalRead(SWITCH1_PIN); delay(1);
     if ((state1 == state2) && (state1==state3))   
     { 
          switch1_State = state1;  
          if ( (switch1_State == HIGH) && (oldswitch1_State == LOW) )
          {
               LED1_State = ! LED1_State;  
               if ( LED1_State == HIGH) 
               {  
                    BTserial.print("<L,1,1>" );  
                    digitalWrite(LED1_PIN,HIGH);  
                    Serial.println("Sent - <L,1,1>");    
               }
                                           
               else                     
               {  
                   BTserial.print("<L,1,0>");   
                   digitalWrite(LED1_PIN,LOW);   
                   Serial.println("Sent - <L,1,0>");    
               }    
          }          
          oldswitch1_State = switch1_State;
      }
}






/*
****************************************
* Function processCommand
* parses data commands contained in receivedChars[]
* receivedChars[] has not been checked for errors
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       receivedChars[]
*       newData
*/
void processCommand()
{

     Serial.print("receivedChars = ");  
     Serial.println(receivedChars);

    if (strcmp ("L10",receivedChars) == 0) 
    {
        digitalWrite(LED1_PIN,LOW);
        LED1_State = LOW; 
        Serial.println("LED1 LOW");  
    }
    
    else if (strcmp ("L11",receivedChars) == 0)
    {
        digitalWrite(LED1_PIN,HIGH);
        LED1_State = HIGH; 
        Serial.println("LED1 HIGH");  
    }




   
    receivedChars[0] = '\0';
    newData = false;
   
}


// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the content between a start marker and an end marker.
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers()
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '<';
     char endMarker = '>';
     char rc;
 
     if (BTserial.available() > 0) 
     {
          rc = BTserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
}



 
 
































