/*
* Sketch: ArduinoSketch_ArduinoBluetoothControl_example004b_Single_analogue_sensor
* By Martyn Currey
* 28.11.2015
* Written in Arduino IDE 1.6.3
*
* Requires the Arduino Bluetooth Control Android App.
*
* See http://www.martyncurrey.com/arduino-bluetooth-control/
*
* Read pin states / values and send to an Android app over bluetooth
* The Android app is initialized by commands sent from the Arduino
*
* The example uses the following pins
* A1 - potentiometer
*/
 
// Change DEBUG to true to output debug information to the serial monitor
const boolean DEBUG = true;
 
 
// The Bluetooth module is connected to pin D2 and D3 and uses software serial
#include <SoftwareSerial.h>
SoftwareSerial BTserial(2,3); // RX | TX
 
char numberString[10];
char rc = ' ';
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newData = false;
 
unsigned long startTime = 0;
unsigned long refreshRate = 2500;
 
unsigned int oldAnalogueVal = 0;
unsigned int newAnalogueVal = 0;
 
 
 
void setup()  
{
  // A1 does not need initializing
  if (DEBUG)
  {
      // open serial communication for debugging
      Serial.begin(9600);
      while (!Serial) {;}
      Serial.println("ArduinoSketch_ArduinoBluetoothControl_example004b_Single_analogue_sensor");
  }
 
 
  //  open software serial connection to the Bluetooth module
  BTserial.begin(9600); 
  if (DEBUG) {  Serial.println("BTserial started at 9600");   }
  newData = false;
  refreshRate = 3000;    // how often to send the init codes
  boolean done = false;
  startTime = millis();
  while (!done)
  {
        if ( millis()-startTime > refreshRate)
        {
            startTime = millis();
            BTserial.print("<START>");                // Start marker
            BTserial.print("<A010000>");              // Initialize analogue pin A01. Start value 0
            BTserial.print("<NA01Potentiometer>");    // set the pin description for A1 to Potentiometer. This may be truncated            
            BTserial.print("<C2>");                   // number of commands not including itself.
            BTserial.print("<END>");                  // End marker
            if (DEBUG) { Serial.println("Sent init commands. Waiting for receipt"); }
        }
 
        recvWithStartEndMarkers(); // check for new data from the Bluetooth module
        if (newData)
        {
            if (  (receivedChars[0] == 'O') & (receivedChars[1] == 'K')  )      { done = true;  }
            else                                                                {newData = false; }            
            if (DEBUG) { Serial.print("receivedChars = "); Serial.println( receivedChars );  }
        }
 
  } // while (!done) 
 
  if (DEBUG)  {  Serial.println("OK received from the app");  } 
 
  // refeshRate is the frequency to check the input pin
  refreshRate = 500;
  startTime = millis();
 
} // void setup()
 
 
void loop()  
{
 
  if ( millis()-refreshRate > startTime)
  {
    startTime = millis();
 
        // Check the value on analogue pin A1
        newAnalogueVal = analogRead(A1);
 
        if ( newAnalogueVal != oldAnalogueVal )
        {
             oldAnalogueVal = newAnalogueVal;
             formatNumber( newAnalogueVal, 4);
             BTserial.print("[A01");  BTserial.print(numberString);  BTserial.print("]");      
             if (DEBUG) { Serial.print("[A01"); Serial.print(numberString); Serial.println("]"); }
        } 
  }
 
} // loop()
 
 
 
 
void formatNumber( unsigned int number, byte digits)
{
    char tempString[10] = "\0"; 
    strcpy(numberString, tempString);
 
    // convert an integer into a acsii string base 10
    itoa (number, tempString, 10);
 
    // create a string of '0' characters to pad the number    
    byte numZeros = digits - strlen(tempString) ;
    if (numZeros > 0)
    {
       for (int i=1; i <= numZeros; i++)    { strcat(numberString,"0");  }
    }
    strcat(numberString,tempString); 
}
 
 
 
// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
void recvWithStartEndMarkers() 
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '<';
     char endMarker = '>';
 
     if (BTserial.available() > 0) 
     {
          rc = BTserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
}
