/*
* Sketch: ArduinoSketch_ArduinoBluetoothControl_example002b_ServoControl
* By Martyn Currey
* 14.11.2015
* Written in Arduino IDE 1.6.3
*
* Requires the Arduino Bluetooth Control Android App.
*
* See http://www.martyncurrey.com/arduino-bluetooth-control/
*
* Control the position of a servo motor
* Uses hardware serial to talk to the Bluetooth module
* Software serial conflicts with the Servo library
*
* The example uses the following pins
* TX1 - hardware serial TX
* RX0 - hardware serial RX
* D5 - servo
*
* It is recommended not to power the servo from the Arduino.
*
*/


#include <Servo.h>
Servo myservo;  // create a servo object 

char rc = ' ';
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newData = false;



void setup()  
{
    myservo.attach(5);
    myservo.write(0); 
  
    // Use the LED on pin 13 to show status 
    // Flashing means sending initialization commands and waiting for a reply
    // On means the Android app has replied correctly
    pinMode(13, OUTPUT); 
    digitalWrite(13,LOW);

    //  open serial connection to the bluetooth module
    Serial.begin(9600); 
    while (!Serial);
    
    // Send initialization commands and the wait for an "OK"   
    boolean LEDisON = false;
    boolean done = false;
    byte count = 0;
    boolean sendInitCodes = true;
      
    newData = false;
    int refreshRate = 250;
    unsigned long startTime = millis();
    while (!done)
    {
        // This bit flashes the LED on pin 13. 
        if ( millis() - startTime > refreshRate)
        {
            startTime = millis();
            if (LEDisON) { LEDisON = false;  digitalWrite(13,LOW);   }
            else         { LEDisON = true;   digitalWrite(13,HIGH);  } 
            count++; 
            // if reply is not received within 3 seconds resend the commands
            if (count==12) { count = 0; sendInitCodes = true;         }
        }
        
        
        // Keep sending the initialization commands until the "OK" reply is received.
        if (sendInitCodes == true)   
        { 
            sendInitCodes = false; 
            Serial.print("<START>");                // Start marker
            Serial.print("<P05000170000>");         // Initialize pin D5 for PWM. min=0, max=170, start val=0
            Serial.print("<ND05Servo Pos>");        // Set the name for D5 to Servo Pos
            Serial.print("<C2>");                   // number of commands not including itself.
            Serial.print("<END>");                  // End marker
        }

        
        recvWithStartEndMarkers(); // check for new data from the Bluetooth module
        if (newData)
        {
            // The Android app receives the commands and sends an "OK" back.
            if (  (receivedChars[0] == 'O') & (receivedChars[1] == 'K')  )
            { done = true;  }
            else 
            {newData = false; }            
        }
        
    } // while (!done) 
  
    // Turn on the built in LED to show the app has received the initialization codes
    digitalWrite(13,HIGH); 
    newData = false; 
    receivedChars[0] = '\0';

  
} // void setup()




void loop()  
{
    recvWithStartEndMarkers();          // check to see if we have received any new commands
    if (newData) { processCommand(); }  // if we have a new command set the Arduino pin accordingly
    delay(5);
}


/*
****************************************
* Function processCommand
* parses data commands contained in receivedChars[]
* receivedChars[] has not been checked for errors
* 
* Passed:
*
* Returns
*  
* Global: 
*       receivedChars[]
*       newData
*
* Sets/Changes:
*        newData
*
*/
void processCommand()
{
    newData = false;
    byte pin = ((receivedChars[1]-48) *10 ) + receivedChars[2]-48;

    // PWM pin
    if ( receivedChars[0] == 'P')
    {
        // convert the ascii value to a numeric value
        byte val = ((receivedChars[3]-48) *100 ) + ((receivedChars[4]-48) * 10)  + (receivedChars[5]-48)   ;
        myservo.write(val);  
    }  
}



// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the content between a start marker and an end marker.
* 
* Passed:
*  
* Returns:
*
* Global: 
*       receivedChars[]
*       newData
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers() 
{
    static boolean recvInProgress = false;
    static byte ndx = 0;
    char startMarker = '<';
    char endMarker = '>';
 
    if (Serial.available() > 0) 
    {
          rc = Serial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
    }

}













