/* 
* Sketch Arduino and Visual Basic Part 2 - Receiving Data From the Arduino
* Send data over serial to Visual Basic
* https://www.martyncurrey.com/arduino-and-visual-basic-part-1-receiving-data-from-the-arduino/
*/

/*
* Pins
* D2 - LED + resistor
* D3 - push button switch
* A4 - potentiometer
*
* It should noted that no data is sent until something changes
* The sketch can be expanded so that an initial value is sent
*/
 
// When DEGUG is TRUE print a newline characters
const boolean DEBUG = true;
 
const byte ledPin = 2;
const byte buttonSwitchPin = 3;
const byte potPin = A4;

boolean newSwitchState1 = LOW;
boolean newSwitchState2 = LOW;
boolean newSwitchState3 = LOW;
boolean oldSwitchState = LOW;

unsigned int oldPotVal = 0;
unsigned int newPotVal = 0;

 
// used to hold an ascii representation of a number
// [10] allows for 9 digits 
char numberString[10];
 
 
void setup()  
{
  pinMode(ledPin, OUTPUT); 
  digitalWrite(ledPin, LOW);
  pinMode(buttonSwitchPin, INPUT); 

  Serial.begin(9600);
  // while (!Serial) {;}
  Serial.println("Adruino is ready");
  Serial.println(" ");
}
 
 
void loop()  
{
    // simple debounce
    newSwitchState1 = digitalRead(buttonSwitchPin);      delay(1);
    newSwitchState2 = digitalRead(buttonSwitchPin);      delay(1);
    newSwitchState3 = digitalRead(buttonSwitchPin);
 
    if (  (newSwitchState1==newSwitchState2) && (newSwitchState1==newSwitchState3) )
    {
        if ( newSwitchState1 != oldSwitchState ) 
        {
            if ( newSwitchState1 == HIGH ) { Serial.print("<BH>"); } else { Serial.print("<BL>"); }
            if (DEBUG) { Serial.println("");  } 
            oldSwitchState = newSwitchState1;
        }   
    }


    // The potentiometer I am using jitters a bit so I only using changes of 3 or more.  
    newPotVal = analogRead(potPin); 
    if ( abs(newPotVal-oldPotVal) > 2)
    {
       oldPotVal = newPotVal;  
       formatNumber( newPotVal, 4);
       Serial.print("<P");   
       Serial.print(numberString);     
       Serial.print(">");
       if (DEBUG) { Serial.println("");  }      
    }    

    if ( newPotVal >= 1000 ) { digitalWrite(ledPin, HIGH);}
    else                     { digitalWrite(ledPin, LOW); }
  
   delay (250);
 }
 
  
void formatNumber( unsigned int number, byte digits)
{
    // Formats a number in to a string and copies it to the global char array numberString
    // Pads the start of the string with '0' characters
    //
    // number = the integer to convert to a string
    // digits = the number of digits to use. 
 
    char tempString[10] = "\0"; 
    strcpy(numberString, tempString);
 
    // convert an integer into a acsii string
    itoa (number, tempString, 10);
 
    // create a string of '0' characters to pad the number    
    byte numZeros = digits - strlen(tempString) ;
    if (numZeros > 0)
    {
       for (int i=1; i <= numZeros; i++)    { strcat(numberString,"0");  }
    }
     strcat(numberString,tempString); 
}
