﻿' Arduino and Visual Basic Part 1: Receiving Data From An Arduino
' A simple example of recieving serial data from an Arduino and displaying it in a text box
' https://www.martyncurrey.com/arduino-and-visual-basic-part-1-receiving-data-from-the-arduino/
'

Imports System
Imports System.IO.Ports
Imports System.Windows.Forms.VisualStyles.VisualStyleElement


Public Class Form1

    ' Global variables.
    ' Anything defined here is available in the whole app
    Dim selected_COM_PORT As String
    Dim receivedData As String = ""

    ' This called when the app first starts. Used to initial what ever needs initialising.
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Timer1.Enabled = False
        selected_COM_PORT = ""
        For Each sp As String In My.Computer.Ports.SerialPortNames
            comPort_ComboBox.Items.Add(sp)
        Next
    End Sub

    ' When the value of the COM PORT drop doewn list changes,
    ' copy the new value to the comPORT variable.
    Private Sub comPort_ComboBox_SelectedIndexChanged(sender As Object, e As EventArgs) Handles comPort_ComboBox.SelectedIndexChanged
        If (comPort_ComboBox.SelectedItem <> "") Then
            selected_COM_PORT = comPort_ComboBox.SelectedItem
        End If
    End Sub

    ' Try to open the com port or close the port if already open
    ' Note: There is no error catching. If the connection attampt fails the app will crash!
    Private Sub connect_BTN_Click(sender As Object, e As EventArgs) Handles connect_BTN.Click
        If (connect_BTN.Text = "CONNECT") Then
            If (selected_COM_PORT <> "") Then

                ' Try allows me to trap an errors such as the COM port not being available
                ' Without it the app crashes.
                Try
                    SerialPort1.PortName = selected_COM_PORT
                    SerialPort1.BaudRate = 9600
                    SerialPort1.DataBits = 8
                    SerialPort1.Parity = Parity.None
                    SerialPort1.StopBits = StopBits.One
                    SerialPort1.DtrEnable = True
                    SerialPort1.RtsEnable = True
                    SerialPort1.Handshake = Handshake.None

                    SerialPort1.Encoding = System.Text.Encoding.Default 'very important!
                    SerialPort1.ReadTimeout = 10000

                    SerialPort1.Open()

                Catch ex As Exception
                    MessageBox.Show(ex.Message + vbCrLf + "Looks like something else is using it.", "Error opening the serial port", MessageBoxButtons.OK, MessageBoxIcon.Error)
                End Try

            Else
                MsgBox("No COM port selected!")
            End If
        Else
            Try
                SerialPort1.Close()
            Catch ex As Exception
                MessageBox.Show("Serial Port is already closed!")
            End Try
        End If

        ' Separating opening the port and setting the variables like this makes the
        ' code a little more clear.
        If (SerialPort1.IsOpen) = True Then
            connect_BTN.Text = "DIS-CONNECT"
            Timer1.Enabled = True
            timer_LBL.Text = "TIMER: ON"
        Else
            connect_BTN.Text = "CONNECT"
            Timer1.Enabled = False
            timer_LBL.Text = "TIMER: OFF"
        End If

    End Sub

    ' Process received data. Append the data to the text box
    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        receivedData = ReceiveSerialData()
        If (receivedData <> "") Then
            recData_RichTextBox.AppendText(receivedData)
        End If


    End Sub

    ' Check for new data
    Function ReceiveSerialData() As String
        Dim Incoming As String = ""
        Try
            Incoming = SerialPort1.ReadExisting()
            If Incoming IsNot Nothing Then
                Return Incoming
            End If
        Catch ex As TimeoutException
            Return "Error: Serial Port read timed out."
        End Try
    End Function

    ' Clear the text box
    Private Sub clear_BTN_Click(sender As Object, e As EventArgs) Handles clear_BTN.Click
        recData_RichTextBox.Text = ""
    End Sub

End Class

