/*
* arduinoBTcontrolUpdated
* Bluetooth remote control from an Arndroid app
* Download the Android app from www.martyncurrey.com
* 
* Written using IDE 1.6.3
* 
* Some of the below code is not very elegant but it should 
* be easy to follow what it does.
* 
* Pins
* 2 Software serial - RX
* 3 Software serial - TX
* 4 LED
* 5 LED
* 6 LED
* 7 LED
* 8 LED
* 9 RGB LED RED PIN
* 10 RGB LED GREEN PIN
* 11 RGB LED BLUE PIN
* 12 LED
* 14 LED
* 15 LED
* 16 LED
* 17 LED
* 18 LED
* 
*/


// DEBUG
// when debug is true, debug messages are sent to the Arduino serial monitor
boolean debug = true;


 
#include <SoftwareSerial.h>
SoftwareSerial BTserial(2,3); // RX | TX
// BT module is connected to pins D2 and D3.
// Arduino RX (pin D2) to BT TX. 
// Arduino TX (pin D3) to BT RX. Needs a voltage divider to bring the voltage down to 3.3V
 
// max length of received command is 20 chrs not including the \0 character
const byte numChars = 21;
char receivedChars[numChars];
boolean newData = false;
 
unsigned int red = 255;
unsigned int green = 255;
unsigned int blue = 255;
 
byte UPpin = 16;
byte DOWNpin = 15;
byte LEFTpin = 14;
byte RIGHTpin = 17;
byte OKpin = 18;
 
 
void setup() 
{
     pinMode(12, OUTPUT); 
     pinMode(8, OUTPUT); 
     pinMode(7, OUTPUT); 
     pinMode(6, OUTPUT); 
     pinMode(5, OUTPUT); 
     pinMode(4, OUTPUT); 
     pinMode(11, OUTPUT);
     pinMode(10, OUTPUT);
     pinMode(9, OUTPUT);
 
     // Common anode RGB lED, 255 is off.
     // If using a common cathod RGB lED then remove the next 3 lines.
     analogWrite(9, red);
     analogWrite(10, green);
     analogWrite(11, blue);  
 
     pinMode(14, OUTPUT); 
     pinMode(15, OUTPUT);      
     pinMode(16, OUTPUT);      
     pinMode(17, OUTPUT); 
     pinMode(18, OUTPUT);   
 
     Serial.begin(9600);
     if (debug) { Serial.println("arduinoBTcontrol Ver 2.0"); }
     if (debug) { Serial.println("For use with the arduinoBTcontrol Android app"); }
     if (debug) { Serial.println(" "); }
 
     // The Bluetooth module used has a default baud rate of 9600
     // This can be changed but be aware software serial doesn't like fast baud rates
     BTserial.begin(9600); 
}


// All the loop function is does is check to see if there is any data from the Bluetooth module 
// and if there is  see if it is a command
void loop() 
{
     if (BTserial.available() > 0)     {  recvWithStartEndMarkers(); }
     if (newData) { parseData(); }
}     
 
 
 
 
 

/*
****************************************
* Function parseData
* checks receivedChars[] for valid commands then acts accordingly
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*
*/
void parseData()
{  
        newData = false;    
        if (debug) { Serial.println( receivedChars ); }    
 
 
        // BUTTON
        // B001ON - B for button. 001 is the button number. ON = on
        // B001OF - B for button. 001 is the button number. OF = off
        if (receivedChars[0] == 'B'  )  
        {
             int tmp = convertToNumber( 1 ); 
             if ( receivedChars[4] == 'O' && receivedChars[5] == 'N' ) { digitalWrite(tmp,HIGH); }
             if ( receivedChars[4] == 'O' && receivedChars[5] == 'F' ) { digitalWrite(tmp,LOW);  }
        } // BUTTON
 
 
        // RGB SLIDER
        // Trrrgggbbb
        if  ( receivedChars[0] == 'T' )
        {  
            // For a common anode RGB LED take the value away from 255.
            // If using a common cathod RGB led then use:
            // red = convertToNumber( 1 );  
            // green  = convertToNumber( 4 );
            // blue = convertToNumber( 7 );  
 
            red = 255 - convertToNumber( 1 );      // convertToNumber converts the ascii numbers to a numeric value
            green  = 255 - convertToNumber( 4 );   // the number is brackets the the start posotion of the value
            blue = 255 - convertToNumber( 7 );  
            analogWrite(9, red);
            analogWrite(10, green);
            analogWrite(11, blue);            
        }  // RGB SLIDER       
 
 
 
        // NAVIGATION
        // NUON - N = navigation. U for UP. ON for on
        // NUOF - N = navigation. U for UP. OF for off
        if ( receivedChars[0] == 'N' )  
        {
              if ( receivedChars[1] == 'U' )   // UP
              { 
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'N'  ) { digitalWrite(UPpin,HIGH); }
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'F'  ) { digitalWrite(UPpin,LOW); }
              }
 
              if ( receivedChars[1] == 'D' )   // DOWN
              {
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'N'  ) { digitalWrite(DOWNpin,HIGH); }
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'F'  ) { digitalWrite(DOWNpin,LOW); }
              }
 
              if ( receivedChars[1] == 'L' )   // LEFT
              {
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'N'  ) { digitalWrite(LEFTpin,HIGH); }
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'F'  ) { digitalWrite(LEFTpin,LOW); }              
 
              }
 
              if ( receivedChars[1] == 'R' )   // RIGHT
              {
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'N'  ) { digitalWrite(RIGHTpin,HIGH); }
                  if ( receivedChars[2] == 'O'  && receivedChars[3] == 'F'  ) { digitalWrite(RIGHTpin,LOW); }              
              }
 
              if ( receivedChars[1] == 'K' )   // OK
              {
                   if ( receivedChars[2] == 'O'  && receivedChars[3] == 'K'  ) 
                   {   digitalWrite(OKpin,HIGH); 
                       delay(75);
                       digitalWrite(OKpin,LOW);
                   }              
              }
 
        } // NAVIGATION
 
 
 
        // COMMAND
        if (strcmp ("CCMD1",receivedChars) == 0) 
        {        
                for ( byte Count = 1; Count <= 15; Count++) 
                {
                    digitalWrite(4,HIGH); delay(100); digitalWrite(4,LOW); 
                    digitalWrite(12,HIGH); delay(100); digitalWrite(12,LOW); 
                }
                 sendOK(1); 
        }        
 
 
        if (strcmp ("CCMD2",receivedChars) == 0) 
        { 
              for ( byte Count = 1; Count <= 5; Count++) 
              {
                  digitalWrite(4,HIGH);  delay(100); digitalWrite(4,LOW); 
                  digitalWrite(5,HIGH);  delay(100); digitalWrite(5,LOW); 
                  digitalWrite(6,HIGH);  delay(100); digitalWrite(6,LOW); 
                  digitalWrite(7,HIGH);  delay(100); digitalWrite(7,LOW); 
                  digitalWrite(8,HIGH);  delay(100); digitalWrite(8,LOW); 
                  digitalWrite(12,HIGH); delay(100); digitalWrite(12,LOW); 
              }
              sendOK(2); 
        }
 
 
        if (strcmp ("CCMD3",receivedChars) == 0)
        {   
            red = 255; green = 255; blue = 255;
            for(int red = 255; red >0;    red--)        {  analogWrite(9, red);     delay (5);   } 
            for(int red = 0;   red < 256; red++)        {  analogWrite(9, red);     delay (5);   } 
            for(int green = 255; green >0;    green--)  {  analogWrite(10, green);  delay (5);   } 
            for(int green = 0;   green < 256; green++)  {  analogWrite(10, green);  delay (5);   } 
            for(int blue = 255; blue >0;    blue--)     {  analogWrite(11, blue);   delay (5);   } 
            for(int blue = 0;   blue < 256; blue++)     {  analogWrite(11, blue);   delay (5);   } 
            sendOK(3); 
        }        

}
 
 
// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the contents between a start marker and an end marker.
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers() 
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '[';
     char endMarker = ']';
 
     char rc;
 
     if (BTserial.available() > 0) 
     {
          rc = BTserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx >= numChars) { ndx = numChars - 1; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
}
 

 

/*
****************************************
* Function convertToNumber
* converts 3 ascii characters to a numeric value
* the 3 characters are inside receivedChars[]
* startPos is the position within receivedChars[] if the first ascii character
* 
* passed:
*  
* global: 
*       receivedChars[]
*
* Returns:
*       an int value   
* 
* Sets:
*
*/ 
int convertToNumber( byte startPos)
{
    unsigned int tmp = 0;
    tmp = (receivedChars[startPos]-48) * 100;
    tmp = tmp + (receivedChars[startPos+1]-48) * 10;
    tmp = tmp + receivedChars[startPos+2]-48;  
    return tmp;
}
 
 
// send a simple finished code to the app 
void sendOK(int val)
{
    BTserial.print("OK");BTserial.print(val);BTserial.print("#");
    if (debug) { Serial.print("OK");Serial.print(val);Serial.println("#"); }
}
