/*
* Sketch: ArduinoSketch_ArduinoBluetoothControl_example001_single_LED_b
* By Martyn Currey
* 01.07.2015
* updated 06.12.2015
* Written in Arduino IDE 1.6.3
*
* Requires the Arduino Bluetooth Control Android App. Can be downloaded from Google Play.
* See http://www.martyncurrey.com/arduino-bluetooth-control/
*
* Turn an LED on and off from an Android app
* Uses the following pins
*
* D2 - software serial RX
* D3 - software serial TX
* D12 - LED
*
*/
 
// The Bluetooth module is connected to pin D2 and D3 and uses software serial
// Remember to use a voltage divider on the TX pin
#include <SoftwareSerial.h>
SoftwareSerial BTserial(2,3); // RX | TX
 
// Change DEBUG to true to output debug information to the serial monitor
const boolean DEBUG = true;
 
 
// Variables used for incoming data
char rc = ' ';
const byte maxDataLength = 20;
char receivedChars[21] ;
boolean newData = false;
 
 
void setup()  
{
 
  // Set the LED pin to output
  pinMode(12, OUTPUT); 
  digitalWrite(12,LOW);
 
 
  if (DEBUG)
  {
      // open serial communication for debugging
      Serial.begin(9600);
      Serial.println("Sketch: ArduinoSketch_ArduinoBluetoothControl_example001_single_LED_b");
      Serial.println(" ");
  }
 
 
  //  open software serial connection to the Bluetooth module
  BTserial.begin(9600); 
 
 
  // Send initialization commands and the wait for a receipt   
  newData = false;
  
  boolean done = false;
  unsigned long startTime = millis();
 
  // keep sending the initialization commands until ew receive an "OK"
  while (!done)
  {
        // send the initialization commands once every second. This can be changed to suit your own sketch.
        if ( millis()-startTime > 1000)
        {
            startTime = millis();
            BTserial.print("<START>");                // Start marker
            BTserial.print("<D12OL>");                // Initialize D12 for output. Start value = LOW
            BTserial.print("<C1>");                   // number of commands including this one
            BTserial.print("<END>");                  // End marker
            if (DEBUG) {  Serial.println( "Initialization commands sent. Waiting for reply" );  }
        }
 
 
        recvWithStartEndMarkers(); // check for new data from the Bluetooth module
 
        if (newData)
        {
            // After the Android app receives the commands it sends an "OK" back.
            if (  (receivedChars[0] == 'O') & (receivedChars[1] == 'K')  )
            { done = true;  }
            else 
            {newData = false; }            
 
            if (DEBUG) { Serial.print("receivedChars = "); Serial.println( receivedChars );  }
        }
 
  } // while (!done) 
 
  if (DEBUG)  { Serial.println("OK received from the app");  } 
 
} // void setup()
 
 
 
void loop()  
{
  recvWithStartEndMarkers();          // check to see if we have received any new commands
  if (newData) { processCommand(); }  // if we have a new command do something
}
 
 
 
/*
****************************************
* Function processCommand
* parses data commands contained in receivedChars[]
* receivedChars[] has not been checked for errors
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*
*/
void processCommand()
{
     newData = false;
 
     if (DEBUG) { Serial.print("receivedChars = ");  Serial.println(receivedChars); }
 
     // does the pin data command start with a "D"
     if ( receivedChars[0] == 'D')
     {
           byte pin = ((receivedChars[1]-48) *10 ) + receivedChars[2]-48;    // get the pin number   
           if (pin == 12)
           {
                if ( receivedChars[3] == 'H') { digitalWrite(pin,HIGH); }
                if ( receivedChars[3] == 'L') { digitalWrite(pin,LOW);  }
           }
     }
}
 
 
 
// function recvWithStartEndMarkers by Robin2 of the Arduino forums
// See  http://forum.arduino.cc/index.php?topic=288234.0
/*
****************************************
* Function recvWithStartEndMarkers
* reads serial data and returns the content between a start marker and an end marker.
* 
* passed:
*  
* global: 
*       receivedChars[]
*       newData
*
* Returns:
*          
* Sets:
*       newData
*       receivedChars
*
*/
void recvWithStartEndMarkers() 
{
     static boolean recvInProgress = false;
     static byte ndx = 0;
     char startMarker = '<';
     char endMarker = '>';
 
     if (BTserial.available() > 0) 
     {
          rc = BTserial.read();
          if (recvInProgress == true) 
          {
               if (rc != endMarker) 
               {
                    receivedChars[ndx] = rc;
                    ndx++;
                    if (ndx > maxDataLength) { ndx = maxDataLength; }
               }
               else 
               {
                     receivedChars[ndx] = '\0'; // terminate the string
                     recvInProgress = false;
                     ndx = 0;
                     newData = true;
               }
          }
          else if (rc == startMarker) { recvInProgress = true; }
     }
 
}
